﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Collections" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Linq" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Ewidencja VAT</title>
	<script runat="server">

		private Boolean agregacjaWgOddzialuSlownikowego = false;
		private Boolean wydrukTekstowy = false;
	
		private SortedList podsumowanie = null;
		private PodsumowanieVATEx podsumowanieWorker = new PodsumowanieVATEx();
		private List<Tuple<GridColumn, Func<PodsumowanieVATEx, Decimal>>> dynamicColumns = new List<Tuple<GridColumn, Func<PodsumowanieVATEx, Decimal>>>();

		
		private String WrapAny(String str)
		{ return String.Format("<span style='word-break:break-all;'>{0}</span>", HttpUtility.HtmlEncode(str)); }


		private void Grid1_BeforeRow(object sender, RowEventArgs args)
		{
			INaglowekVAT nag = (INaglowekVAT)args.Row;
			DokEwidencji ewid = nag.Ewidencja;
			
			if (Param.Zaplacone)
			{
				Date data = Date.MaxValue;
				string dokumenty = "";
				foreach (Platnosc p in ewid.Platnosci)
				{
					if (!(p.DataRozliczenia < Date.MaxValue))
					{
						args.VisibleRow = false;
						return;
					}

					data = Date.Min(p.DataRozliczenia, data);
					dokumenty += p.RozliczoneDokumenty;
				}
				colZaplaty.EditValue = string.Format("{0} - {1}", data, dokumenty);
			}

			if (Param.OpisUslugi)
				colOpisyUslug.EditValue = ((VATEwidencja)ewid).OpisVATUslug;

			if (Param.OkresRozliczeniaVAT != FromTo.All)
			{
				NagRozliczeniaVAT nagRoz = nag as NagRozliczeniaVAT;
				if (nagRoz != null && !Param.OkresRozliczeniaVAT.Contains(nagRoz.Data))
				{
					args.VisibleRow = false;
					return;
				}

				NagEwidencjiVAT nagEwid = nag as NagEwidencjiVAT;
				if (nagEwid != null)
				{
					if (nagEwid.NaglowkiRozliczeniaVAT.IsEmpty)
					{
						args.VisibleRow = false;
						return;
					}
					foreach (NagRozliczeniaVAT n in nagEwid.NaglowkiRozliczeniaVAT)
					{
						if (!Param.OkresRozliczeniaVAT.Contains(n.Data))
						{
							args.VisibleRow = false;
							return;
						}
					}
				}
			}

			if (Param.OkresKsiegowania != FromTo.All && !Param.OkresKsiegowania.Contains(nag.Ewidencja.DataKsiegowania))
			{
				args.VisibleRow = false;
				return;
			}

			colNumer.EditValue = WrapAny(nag.Numer);
			colNumerDokumentu.EditValue = WrapAny(nag.NumerDokumentu);
			colDataDokumentu.EditValue = nag.DataDokumentu;
			colDefinicja.EditValue = nag.Definicja.Symbol;

			DaneKontrahenta danePodmiotu = ((PodmiotEwidencja)nag.Ewidencja).DaneKontrahenta;

			string kod = nag.Podmiot.Kod;
			if (danePodmiotu.EuVAT != "")
				kod += string.Format(" ({0})", danePodmiotu.EuVAT);
			colKod.EditValue = kod;
			colNazwa.EditValue = string.Format("{0} {1}", danePodmiotu.Nazwa, danePodmiotu.Adres);

			podsumowanieWorker.Naglowek = nag;
			colNettoZw.EditValue = podsumowanieWorker.SumaWgStawek["ZW"].Netto.Value;
			colNetto0.EditValue = podsumowanieWorker.SumaWgStawek["0%"].Netto.Value;
			colNettoNP.EditValue = podsumowanieWorker.SumaWgStawek["NP"].Netto.Value;
            colNetto.EditValue = podsumowanieWorker.SumaWgStawek["NP"].Netto.Value;
            colNettoBrak.EditValue = podsumowanieWorker.SumaWgStawek["-"].Netto.Value;
			colNetto.EditValue = podsumowanieWorker.Suma.Netto.Value;
			colVAT.EditValue = podsumowanieWorker.Suma.VAT.Value;
			colBrutto.EditValue = podsumowanieWorker.Suma.Brutto.Value;

			foreach (var dynCol in dynamicColumns)
				dynCol.Item1.EditValue = dynCol.Item2(podsumowanieWorker);

			if (Param.SposobSumowania != SposobSumowania.Brak)
			{
				object grpKey = calcGroupKey(nag);

				if (Param.ZakresDruku == ZakresDrukuTp.ListGrouped || Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary)
					Grid1.GroupLine = grpKey.ToString();

				if (podsumowanie.ContainsKey(grpKey))
					((Podsumowanie)podsumowanie[grpKey]).Add(podsumowanieWorker);
				else
				{
					Podsumowanie pod = new Podsumowanie(grpKey);
					pod.Add(podsumowanieWorker);
					podsumowanie.Add(grpKey, pod);
				}
			}
		}


		public class ProxyOdddzial
		{
			private readonly OddzialFirmy odd;
			private readonly String symbol;


			public String Symbol
			{ get { return symbol; } }

			public override string ToString()
			{ return Symbol; }

			public ProxyOdddzial(OddzialFirmy o)
			{
				odd = o;
				symbol = o != null ? o.Symbol : "(bez oddziału)";
			}
		}


		public class ProxyCust : IComparable<ProxyCust>
		{
			private readonly String country;
			private readonly String nip;

			
			public ProxyCust(INaglowekVAT nag)
			{
				EuVat.Split(nag.Podmiot.EuVAT, out country, out nip);
				nip = EuVat.Flat(nip);
			}

			
			public override string ToString()
			{ return String.IsNullOrEmpty(country) ? nip : country + "-" + nip; }


			public int CompareTo(ProxyCust other)
			{
				if (other == null)
					throw new ArgumentNullException("ProxyCust.CompareTo.other");

				int comp;
				
				if ((comp = country.CompareTo(other.country)) != 0)
					return comp;
				if ((comp = nip.CompareTo(other.nip)) != 0)
					return comp;

				return 0;				
			}
		}


		private object calcGroupKey(INaglowekVAT nag)
		{
			Debug.Assert(nag != null);
			Debug.Assert(Param.SposobSumowania != SposobSumowania.Brak);

			switch (Param.SposobSumowania)
			{
				case SposobSumowania.WgMiesiącaDokumentu:
					return nag.Ewidencja.DataDokumentu.ToYearMonth();

				case SposobSumowania.WgMiesiącaEwidencji:
					return nag.Ewidencja.DataEwidencji.ToYearMonth();

				case SposobSumowania.WgMiesiącaWpływu:
					return nag.Ewidencja.DataWplywu.ToYearMonth();

				case SposobSumowania.WgMiesiącaOperacji:
					return nag.Ewidencja.DataOperacji.ToYearMonth();

				case SposobSumowania.WgMiesiącaZaewidencjonowania:
					if (nag is NagEwidencjiVAT)
						return ((NagEwidencjiVAT)nag).DataZaewidencjonowania.ToYearMonth();
					else
						return ((NagRozliczeniaVAT)nag).Naglowek.DataZaewidencjonowania.ToYearMonth();

				case SposobSumowania.WgMiesiącaRozliczenia:
					if (nag is NagEwidencjiVAT)
						return ((NagEwidencjiVAT)nag).DataRozliczenia.ToYearMonth();
					else
						return ((NagRozliczeniaVAT)nag).Data.ToYearMonth();

				case SposobSumowania.WgOddziałów:
					return new ProxyOdddzial(agregacjaWgOddzialuSlownikowego ? nag.Ewidencja.Oddzial.GetOddzialTypu(OddzialParamsType.Słownikowe, true) : nag.Ewidencja.Oddzial);

				case SposobSumowania.WgPodmiotu:
					return new ProxyCust(nag);

				default:
					throw new ApplicationException("calcGroupKey::kryterium: " + Param.SposobSumowania);
			}
		}


		private int CompareNags(INaglowekVAT op1, INaglowekVAT op2)
		{
			Debug.Assert(Param.SposobSumowania != SposobSumowania.Brak);
			return KeyComparer.Instance.Compare(calcGroupKey(op1), calcGroupKey(op2));
		}
	

		private void EwidencjaVAT_OnLoad(Object sender, EventArgs args)
		{
			podsumowanie = new SortedList(KeyComparer.Instance);
			
			podsumowanieWorker.Param = null;
			IEnumerable dataSource = null;

			Soneta.EwidencjaVat.NagRozliczenVATT.ParamsEx px = (Soneta.EwidencjaVat.NagRozliczenVATT.ParamsEx)DataContext1.Context[typeof(Soneta.EwidencjaVat.NagRozliczenVATT.ParamsEx), false];
		
			if (DataContext1.Context.Contains(typeof(NagEwidencjiVATT.ParamsEx)))
				podsumowanieWorker.Param = (NagEwidencjiVATT.ParamsEx)DataContext1.Get(typeof(NagEwidencjiVATT.ParamsEx));

			if (podsumowanieWorker.Param == null)
			{
				podsumowanieWorker.Param = new NagEwidencjiVATT.ParamsEx(DataContext1.Context, true);
				podsumowanieWorker.Param.Typ = TypEwidencjiVAT.Sprzedaż;

				if (DataContext1.Context.Contains(typeof(DokHandloweViewInfo.WParams)))
					podsumowanieWorker.Param.Zakres = ((DokHandloweViewInfo.WParams)DataContext1.Get(typeof(DokHandloweViewInfo.WParams))).Okres;
				else
					podsumowanieWorker.Param.Zakres = ((OkresContext)DataContext1.Get(typeof(OkresContext))).Okres;

				Grid1.DataSource = dataSource = new SubTable(EwidencjaVatModule.GetInstance(DataContext1.Session).NagEwidencjiVATT.WgTyp[podsumowanieWorker.Param.Typ], podsumowanieWorker.Param.Zakres);
			}
			else
				dataSource = (Soneta.Business.View)DataContext1.Get(typeof(Soneta.Business.View));

			if (Param.ZakresDruku == ZakresDrukuTp.ListGrouped || Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary)
			{
				List<INaglowekVAT> lst = new List<INaglowekVAT>();
				foreach (INaglowekVAT nag in dataSource)
					lst.Add(nag);

				lst.Sort(CompareNags);
				
				Grid1.DataSource = lst;
				Grid1.RowTypeName = typeof(NagEwidencjiVAT).ToString();
			}

			string tytul = "";
			if (podsumowanieWorker.Param is NagRozliczenVATT.ParamsEx)
			{
				colData.Caption = "Data roz.";
				colData.DataMember = "Data";
				tytul = "Rejestr VAT";
			}
			else
			{
				colData.DataMember = "DataZaewidencjonowania";
				tytul = "Ewidencja VAT";
			}

			if (wydrukTekstowy)
				colNumer.Width = 14 + 40;

			if (Param.DefinicjeStawekVAT != null && Param.DefinicjeStawekVAT.Length != 0)
			{
				int idx = Grid1.Columns.IndexOf(colDefinicja);
				int idxP = Grid2.Columns.IndexOf(colMiesiac);
				foreach (DefinicjaStawkiVat defVAT in Param.DefinicjeStawekVAT)
				{
					GridColumn gcNetto = new GridColumn();
					gcNetto.Caption = string.Format("Netto {0}", defVAT.Kod);
					gcNetto.Format = "{0:n}";
					gcNetto.Width = 11;
					gcNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcNetto.Total = Soneta.Web.Total.Sum;

					String vKod = defVAT.Kod;
					dynamicColumns.Add(Tuple.Create<GridColumn, Func<PodsumowanieVATEx, Decimal>>(gcNetto, w => w.SumaWgStawek[vKod].Netto.Value));
					Grid1.Columns.Insert(++idx, gcNetto);

					GridColumn gcVAT = new GridColumn();
					gcVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
					gcVAT.Format = "{0:n}";
					gcVAT.Width = 11;
					gcVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcVAT.Total = Soneta.Web.Total.Sum;

					dynamicColumns.Add(Tuple.Create<GridColumn, Func<PodsumowanieVATEx, Decimal>>(gcVAT, w => w.SumaWgStawek[vKod].VAT.Value));
					Grid1.Columns.Insert(++idx, gcVAT);

					colNazwa.ColSpan++;
					colZaplaty.ColSpan++;
					colOpisyUslug.ColSpan++;
					if (wydrukTekstowy)
						colNumer.Width -= 11;

					GridColumn gcPNetto = new GridColumn();
					gcPNetto.Caption = string.Format("Netto {0}", defVAT.Kod);
					gcPNetto.DataMember = string.Format("{0}.Netto.Value", defVAT.Kod);
					gcPNetto.Format = "{0:n}";
					gcPNetto.Width = 11;
					gcPNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcPNetto.Total = Soneta.Web.Total.Sum;
					Grid2.Columns.Insert(++idxP, gcPNetto);

					GridColumn gcPVAT = new GridColumn();
					gcPVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
					gcPVAT.DataMember = string.Format("{0}.VAT.Value", defVAT.Kod);
					gcPVAT.Format = "{0:n}";
					gcPVAT.Width = 11;
					gcPVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
					gcPVAT.Total = Soneta.Web.Total.Sum;
					Grid2.Columns.Insert(++idxP, gcPVAT);

					colMiesiac.ColSpan++;
				}
			}

			if (!Param.Zaplacone)
			{
				Grid1.Columns.Remove(colZaplaty);
				colLp.RowSpan--;
				Grid1.RowsInRow--;
			}

			if (!Param.OpisUslugi)
			{
				Grid1.Columns.Remove(colOpisyUslug);
				colLp.RowSpan--;
				Grid1.RowsInRow--;
			}


			string tytulOddzial = String.Empty;
			OddzialParamsBase opb = (OddzialParamsBase)DataContext1.Get(typeof(OddzialParamsBase));
			if (opb.OddzialowoscEnabled)
				tytulOddzial += " | Oddział: " + opb.Oddział.ToString();

			string tytulNaglowka = string.Format("{0}{10} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3},{11} Podmiot: {4}, Korekty: {5} |Działalność: {12}, Odliczenia: {6}|Rodzaj: {7}, Rodzaj pod.: {8}, Status pod.: {9}|{13}",
					tytul, 
					podsumowanieWorker.Param.Typ, 
					podsumowanieWorker.Param.Zakres,
					podsumowanieWorker.Param.Definicja == null ? "Wszystkie" : podsumowanieWorker.Param.Definicja.ToString(),
					podsumowanieWorker.Param.Podmiot == null ? "Wszyscy" : podsumowanieWorker.Param.Podmiot.ToString(), 
					podsumowanieWorker.Param.Korekty, 
					CaptionAttribute.EnumToString(podsumowanieWorker.Param.Odliczenia), 
					podsumowanieWorker.Param.RodzajZakupu, 
					podsumowanieWorker.Param.RodzajPodmiotu, 
					podsumowanieWorker.Param.StatusPodmiotu,
					tytulOddzial,
					px != null ? String.Format("Typ rozliczenia: {0}|", CaptionAttribute.EnumToString(px.TypRozliczenia)) : String.Empty,
			        CaptionAttribute.EnumToString(podsumowanieWorker.Param.DzialalnoscGospodarcza),
    			    podsumowanieWorker.Param.ApplyAspxParamsForProceduresVAT()
            );

			if (podsumowanieWorker.Param.Porownanie != TypPorownania.Brak)
				tytulNaglowka = string.Format("{0} | Kwota brutto {1} {2:n}", tytulNaglowka, CaptionAttribute.EnumToString(podsumowanieWorker.Param.Porownanie), podsumowanieWorker.Param.Kwota);
			if (Param.OkresRozliczeniaVAT != FromTo.All)
				tytulNaglowka += string.Format("| Okres roz. VAT: {0}", Param.OkresRozliczeniaVAT);
			if (Param.OkresKsiegowania != FromTo.All)
				tytulNaglowka += string.Format("| Okres księgowania: {0}", Param.OkresKsiegowania);

			if (Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary || Param.ZakresDruku == ZakresDrukuTp.ListSummary || Param.ZakresDruku == ZakresDrukuTp.SummaryOnly)
			{
				Grid2.DataSource = podsumowanie.Values;
				colMiesiac.Caption = String.Format("Podsumowanie --- {0}", CaptionAttribute.ConvertName(Param.SposobSumowania.ToString()).ToLower());
			}
			else
			{
				Grid2.Visible = false;
			}

			if (Param.ZakresDruku == ZakresDrukuTp.SummaryOnly)
			{
				Grid1.Visible = false;
				foreach (object r in (Soneta.Business.View)DataContext1.Get(typeof(Soneta.Business.View)))
					Grid1_BeforeRow(null, new RowEventArgs(r, 0, null));
			}

			if (Param.ZakresDruku == ZakresDrukuTp.ListGrouped || Param.ZakresDruku == ZakresDrukuTp.ListGroupedSummary)
			{
				Grid1.ShowAgrSum = false;
				Grid1.ShowPageSum = false;
				Grid1.ShowPrevAgrSum = PrevAgrSum.None;
				Grid1.ShowGroupSum = true;
				Grid1.GroupLine = "DELTRA";
				Grid1.GroupSumText = "Dla grupy";
			}

			if (!wydrukTekstowy)
				ReportHeader1.Title = tytulNaglowka;
		}

		
		private class KeyComparer : IComparer
		{
			public static KeyComparer Instance = new KeyComparer();


			private KeyComparer()
			{ }

			
			public int Compare(object x, object y)
			{
				if (x is YearMonth)
					return ((YearMonth)x).CompareTo((YearMonth)y);
				if (x is ProxyOdddzial)
					return ((ProxyOdddzial)x).Symbol.CompareTo(((ProxyOdddzial)y).Symbol);
				if (x is ProxyCust)
					return ((ProxyCust)x).CompareTo((ProxyCust)y);

				throw new ArgumentException("KeyComparer.Compare.x :: " + (x != null ? x.GetType().ToString() : "<null>"));
			}
		}

		
		public class Podsumowanie : ICustomTypeDescriptor
		{
			private readonly object kategoria;
			private Session session = null;
			DictionaryZero<string, NettoVATBrutto> wgStawek = new DictionaryZero<string, NettoVATBrutto>();
			NettoVATBrutto suma = new NettoVATBrutto(0, 0, 0);


			string ICustomTypeDescriptor.GetComponentName()
			{ return TypeDescriptor.GetComponentName(this, true); }

			object ICustomTypeDescriptor.GetPropertyOwner(PropertyDescriptor pd)
			{ return this; }

			PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties(System.Attribute[] attributes)
			{ return TypeDescriptor.GetProperties(this, attributes, true); }

			PropertyDescriptorCollection ICustomTypeDescriptor.GetProperties()
			{
				PropertyDescriptorCollection pdc = new PropertyDescriptorCollection(null);
				foreach (PropertyDescriptor pd in TypeDescriptor.GetProperties(this, true))
					pdc.Add(pd);

				foreach (string kodStawki in GetNames(session))
					pdc.Add(new NettoVATBruttoDescriptor(this, kodStawki));
				return pdc;
			}

			PropertyDescriptor ICustomTypeDescriptor.GetDefaultProperty()
			{ return TypeDescriptor.GetDefaultProperty(this, true); }

			object ICustomTypeDescriptor.GetEditor(System.Type editorBaseType)
			{ return TypeDescriptor.GetEditor(this, editorBaseType, true); }

			EventDescriptor ICustomTypeDescriptor.GetDefaultEvent()
			{ return TypeDescriptor.GetDefaultEvent(this, true); }

			TypeConverter ICustomTypeDescriptor.GetConverter()
			{ return TypeDescriptor.GetConverter(this, true); }

			EventDescriptorCollection ICustomTypeDescriptor.GetEvents(System.Attribute[] attributes)
			{ return TypeDescriptor.GetEvents(this, attributes, true); }

			EventDescriptorCollection ICustomTypeDescriptor.GetEvents()
			{ return TypeDescriptor.GetEvents(this, true); }

			System.ComponentModel.AttributeCollection ICustomTypeDescriptor.GetAttributes()
			{ return TypeDescriptor.GetAttributes(this, true); }

			string ICustomTypeDescriptor.GetClassName()
			{ return TypeDescriptor.GetClassName(this, true); }


			public class NettoVATBruttoDescriptor : PropertyDescriptor
			{
				private readonly Podsumowanie podsumowanie;
				private readonly string kodStawki;

				internal NettoVATBruttoDescriptor(Podsumowanie podsumowanie, string kodStawki)
					: base(kodStawki, null)
				{
					this.podsumowanie = podsumowanie;
					this.kodStawki = kodStawki;
				}

				public override bool IsReadOnly
				{ get { return true; } }

				public override Type PropertyType
				{ get { return typeof(NettoVATBrutto); } }

				public override System.ComponentModel.AttributeCollection Attributes
				{ get { return new System.ComponentModel.AttributeCollection(null); } }

				public override Type ComponentType
				{ get { return typeof(Podsumowanie); } }

				public override bool CanResetValue(object podsumowanie)
				{
					System.Diagnostics.Debug.Assert(podsumowanie == this.podsumowanie);
					return false;
				}

				public override object GetValue(object podsumowanie)
				{
					System.Diagnostics.Debug.Assert(podsumowanie == this.podsumowanie);
					return ((Podsumowanie)podsumowanie)[kodStawki];
				}

				public override void ResetValue(object podsumowanie)
				{ throw new InvalidOperationException(); }

				public override void SetValue(object podsumowanie, object value)
				{ throw new InvalidOperationException(); }

				public override bool ShouldSerializeValue(object blok)
				{ return false; }
			}


			public Podsumowanie(object kategoria)
			{ this.kategoria = kategoria; }

			public object Kategoria
			{ get { return kategoria; } }

			
			public void Add(PodsumowanieVATEx podsumowanie)
			{
				if (session == null)
					session = podsumowanie.Naglowek.Session;
				
				Soneta.EwidencjaVat.NettoVATBrutto s = podsumowanie.Suma;
				suma.Add(s.Netto, s.VAT, s.Brutto);
				
				foreach (string kodStawki in NettoVATBruttoWgStawek.GetNames(podsumowanie.Naglowek.Session))
				{
					s = podsumowanie.SumaWgStawek[kodStawki];
					if (wgStawek.ContainsKey(kodStawki))
						wgStawek[kodStawki].Add(s.Netto, s.VAT, s.Brutto);
					else
						wgStawek.Add(kodStawki, new NettoVATBrutto(s.Netto, s.VAT, s.Brutto));
				}
			}


			public static IEnumerable GetNames(Session session)
			{
				ArrayList arr = new ArrayList();
				foreach (DefinicjaStawkiVat def in CoreModule.GetInstance(session).DefStawekVat)
					arr.Add(def.Kod);
				return arr;
			}


			public NettoVATBrutto this[string kodStawki]
			{
				get
				{
					if (wgStawek.ContainsKey(kodStawki))
						return wgStawek[kodStawki];
					return new NettoVATBrutto(0, 0, 0);
				}
			}

			
			public NettoVATBrutto Suma
			{ get { return suma; } }
		}

		
		public class NettoVATBrutto
		{
			Currency netto, vat, brutto;

			public NettoVATBrutto(Currency netto, Currency vat, Currency brutto)
			{
				this.netto = netto;
				this.vat = vat;
				this.brutto = brutto;
			}

			public void Add(Currency netto, Currency vat, Currency brutto)
			{
				this.netto += netto;
				this.vat += vat;
				this.brutto += brutto;
			}

			public Currency Netto { get { return netto; } }
			public Currency VAT { get { return vat; } }
			public Currency Brutto { get { return brutto; } }

		}

		[Context]
		public Params Param { get; set; }

		
		public enum SposobSumowania
		{
			[Caption("-- Brak --")]
			Brak,
			[Caption("Miesiąc zaewidencjonowania")]
			WgMiesiącaZaewidencjonowania,
			[Caption("Miesiąc rozliczenia")]
			WgMiesiącaRozliczenia,
			[Caption("Miesiąc wpływu")]
			WgMiesiącaWpływu,
			[Caption("Miesiąc ewidencji")]
			WgMiesiącaEwidencji,
			[Caption("Miesiąc dokumentu")]
			WgMiesiącaDokumentu,
			[Caption("Miesiąc operacji")]
			WgMiesiącaOperacji,
			[Caption("Podmiot (EuVAT)")]
			WgPodmiotu,
			[Caption("Oddział")]
			WgOddziałów,
		}


		public enum ZakresDrukuTp
		{
			[Caption("Szczegóły")]
			List,
			[Caption("Szczegóły + Podsumowanie")]
			ListSummary,
			[Caption("Szczegóły (gr.)")]
			ListGrouped,
			[Caption("Szczegóły (gr.) + Podsumowanie")]
			ListGroupedSummary,
			[Caption("Podsumowanie")]
			SummaryOnly,
		}

		
		public class Params : SerializableContextBase
		{
			private Boolean zaplacone = false;
			private Boolean opisUslugi = false;
			private ZakresDrukuTp zakresDruku = ZakresDrukuTp.List;
			private DefinicjaStawkiVat[] definicjeStawekVAT = null;
			private FromTo okresRozliczeniaVAT = FromTo.All;
			private FromTo okresKsiegowania = FromTo.All;
			private SposobSumowania sposobSumowania = SposobSumowania.Brak;
			
						
			public Params(Context cx)
				: base(cx)
			{}

			
			[Caption("Tylko zapłacone")]
			[Priority(10)]
			public bool Zaplacone
			{
				get { return zaplacone; }
				set { zaplacone = value; }
			}

			
			[Caption("Opisy VAT usług")]
			[Priority(20)]
			public bool OpisUslugi
			{
				get { return opisUslugi; }
				set { opisUslugi = value; }
			}

			
			[Soneta.Business.Required]
			[Caption("Kolumny(stawki VAT)")]
			[Priority(30)]
			[DefaultWidth(25)]
			public DefinicjaStawkiVat[] DefinicjeStawekVAT
			{
				get { return definicjeStawekVAT; }
				set { definicjeStawekVAT = value; }
			}

			
			public LookupInfo.Item GetListDefinicjeStawekVAT()
			{
				var coreModule = CoreModule.GetInstance(Session);

				var view = coreModule.DefStawekVat.CreateDefaultView();
				view.Condition &= new FieldCondition.NotEqual("Stawka.Procent", new Percent(0));
				view.Condition &= new FieldCondition.Equal("Stawka.Kraj", coreModule.KrajeTbl.Poland);

				return CoreModule.GetInstance(Session).DefStawekVat.GetDefaultLookup(view);
			}

			
			[Caption("Okres rozlicz. VAT ")]
			[Priority(40)]
			[DefaultWidth(25)]
			public FromTo OkresRozliczeniaVAT
			{
				get { return okresRozliczeniaVAT; }
				set
				{
					if (value == FromTo.Empty)
						value = FromTo.All;
					okresRozliczeniaVAT = value;
					OnChanged(EventArgs.Empty);
				}
			}

			
			[Caption("Okres księgowania")]
			[Priority(50)]
			[DefaultWidth(25)]
			public FromTo OkresKsiegowania
			{
				get { return okresKsiegowania; }
				set
				{
					if (value == FromTo.Empty)
						value = FromTo.All;

					okresKsiegowania = value; OnChanged(EventArgs.Empty);
				}
			}

			
			[Caption("Kryterium")]
			[Priority(60)]
			[DefaultWidth(25)]
			public SposobSumowania SposobSumowania
			{
				get { return sposobSumowania; }
				set
				{
					sposobSumowania = value;

					if (sposobSumowania == SposobSumowania.Brak)
						zakresDruku = ZakresDrukuTp.List;
					else if (zakresDruku == ZakresDrukuTp.List)
						zakresDruku = ZakresDrukuTp.ListSummary;
						
					OnChanged(EventArgs.Empty);
				}
			}

			
			public object[] GetListSposobSumowania()
			{
				System.Collections.ArrayList list =  new ArrayList(Enum.GetValues(typeof(SposobSumowania)));
				
				if (!CoreModule.GetInstance(Session).DokEwidencja.Wielooddziałowość)
					list.Remove(SposobSumowania.WgOddziałów);

				return list.ToArray();
			}


			[Caption("Zakres wydruku")]
			[Priority(70)]
			[DefaultWidth(25)]
			public ZakresDrukuTp ZakresDruku
			{
				get { return zakresDruku; }
				set
				{
					zakresDruku = value;
					OnChanged(EventArgs.Empty);
				}
			}


			public Boolean IsReadOnlyZakresDruku()
			{ return sposobSumowania == SposobSumowania.Brak; }
		}
		
		
	</script>

</head>
<body>
	<form id="EwidencjaVAT" method="post" runat="server">
	<ea:DataContext ID="DataContext1" OnContextLoad="EwidencjaVAT_OnLoad" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business" BottomMargin="10" LeftMargin="10" RightMargin="10" 
        TopMargin="10" />
	<cc1:ReportHeader ID="ReportHeader1" Title="Ewidencja VAT" runat="server"></cc1:ReportHeader>

	<ea:Grid ID="Grid1" runat="server" ShowAgrSum="True" ShowPageSum="True" ShowPrevAgrSum="InFooter" OnBeforeRow="Grid1_BeforeRow" RowsInRow="5" RowTypeName="Soneta.EwidencjaVat.NagEwidencjiVAT,Soneta.Ksiega">
		<Columns>
			<ea:GridColumn runat="server" Width="5" DataMember="#" Caption="Lp" ID="colLp" RowSpan="5" />
			<ea:GridColumn runat="server" Caption="Nr ewid." ID="colNumer" />
			<ea:GridColumn runat="server" Align="Right" Caption="Nr dok." ID="colNumerDokumentu" />
			<ea:GridColumn runat="server" ColSpan="5" Caption="Podmiot (Nazwa + Adres)" ID="colNazwa" EncodeHTML="True" />
			<ea:GridColumn runat="server" ColSpan="6" Caption="Zapłaty" ID="colZaplaty" EncodeHTML="True" />
			<ea:GridColumn runat="server" ColSpan="6" Caption="Opisy usług" ID="colOpisyUslug" EncodeHTML="True" />
			<ea:GridColumn runat="server" Width="10" Align="Center" Caption="Data zaew." ID="colData" />
			<ea:GridColumn runat="server" ColSpan="2" Align="Center" Caption="Podmiot (Kod + NIP)" ID="colKod" EncodeHTML="True" Total="Info" />
			<ea:GridColumn runat="server" Width="10" Align="Center" Caption="Data dok." ID="colDataDokumentu" />
			<ea:GridColumn runat="server" Width="8" Align="Center" Caption="Def." ID="colDefinicja" EncodeHTML="True" Visible="False"/>
			<ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. 0%" Format="{0:n}" ID="colNetto0" />
            <ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. zw." Format="{0:n}" ID="colNettoZw" />
			<ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. NP" Format="{0:n}" ID="colNettoNP" />
            <ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. -" Format="{0:n}" ID="colNettoBrak" />
			<ea:GridColumn runat="server" Width="12" Align="Right" Total="Sum" Caption="Netto" Format="{0:n}" ID="colNetto" />
			<ea:GridColumn runat="server" Width="12" Align="Right" Total="Sum" Caption="VAT" Format="{0:n}" ID="colVAT" />
			<ea:GridColumn runat="server" Width="12" Align="Right" Total="Sum" Caption="Brutto" Format="{0:n}" ID="colBrutto" />
		</Columns>
	</ea:Grid>

	<br>

	<ea:Grid ID="Grid2" runat="server" RowsInRow="3">
		<Columns>
			<ea:GridColumn runat="server" DataMember="#" Caption="Lp" RowSpan="2" />
			<ea:GridColumn runat="server" Caption="Miesiąc" DataMember="Kategoria" EncodeHTML="true" ColSpan="3" ID="colMiesiac" Total="Info" />
			<ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. 0%" Format="{0:n}" DataMember="0%.Netto.Value" />
            <ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. zw." Format="{0:n}" DataMember="ZW.Netto.Value"/>
			<ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. NP" Format="{0:n}" DataMember="NP.Netto.Value" />
            <ea:GridColumn runat="server" Width="11" Align="Right" Total="Sum" Caption="Wart. -" Format="{0:n}" DataMember="-.Netto.Value" />
			<ea:GridColumn runat="server" Width="12" Align="Right" Total="Sum" Caption="Netto" Format="{0:n}" DataMember="Suma.Netto.Value" />
			<ea:GridColumn runat="server" Width="12" Align="Right" Total="Sum" Caption="VAT" Format="{0:n}" DataMember="Suma.VAT.Value" />
			<ea:GridColumn runat="server" Width="12" Align="Right" Total="Sum" Caption="Brutto" Format="{0:n}" DataMember="Suma.Brutto.Value" />
		</Columns>
	</ea:Grid>

	<br>

	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="OperatorCzas" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

